//=========================================================================
///	<summary>
///		ڂJ_[ ICf[^擾NX
///	</summary>
/// <remarks>
/// </remarks>
/// <history>2006/XX/XX VK쐬 Dr.Kurusugawa</history>
/// <history>2010/05/01 SubversionŊǗ邽ߕsvȃRg폜</history>
//=========================================================================
using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Net;
using System.Xml;
using System.IO;
using System.Collections;
using System.Web;
using  System.Windows.Forms;
using magicAnime.Properties;

namespace magicAnime
{
	//=========================================================================
	///	<summary>
	///		ڂJ_[f[^擾NX
	///	</summary>
	/// <remarks>
	/// </remarks>
	/// <history>2006/XX/XX VK쐬</history>
	//=========================================================================
	class SyoboiCalender
	{
		DateTime?	prevUpdateListGetTime	= null;			// O̍XVXg擾

		// ^CgXge[u(http://cal.syoboi.jp/titlelist.php)
		// ^Cg		I	Point	TID	XV
		
		//=========================================================================
		///	<summary>
		///		ڂ̔ԑgf[^ێNX
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public class SyoboiProgram
		{
			public string title;
			public 	struct SeasonOnAir
			{
				public const	uint YearDecided		= 1;
				public const	uint MonthDecided		= 2;
				public uint	RecordState;
				public int		year;
				public int		month;
				public override string ToString()
				{
					return string.Format(
						"{0:0}-{1:0}",
						((RecordState&YearDecided)>0)?year.ToString():"????",
						((RecordState&MonthDecided)>0)?month.ToString():"??");
				}
			};
			public SeasonOnAir seasonOnAir;
			
			public int	tid;
			
		}

		//=========================================================================
		///	<summary>
		///		ڂ̃Gs\[hf[^ێNX
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public class SyoboiRecord : ICloneable
		{
			public int number;
			public string subtitle;
			public string tvStation;
			public int length;
			
			public DateTime onAirDateTime;

			public System.Object Clone()
			{
				return this.MemberwiseClone();
			}
		}

		public class SyoboiUpdate
		{
			public int tid;
			public DateTime updateDate;
		}
		
		//=========================================================================
		///	<summary>
		///		mAgicAnimeŗLUser-AgentԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2007/12/22 VK쐬</history>
		//=========================================================================
		public string UserAgent
		{
			get
			{
				return "mAgicAnime " + Application.ProductVersion.ToString();
			}
		}

		//=========================================================================
		///	<summary>
		///		ڂRSSXVꂽԑgXg擾
		///	</summary>
		/// <remarks>
		///		XVȂꍇ͋̃XgԂB
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		/// <history>2009/02/11 ڂ镉ב΍̂if-modified-sinceǉ</history>
		//=========================================================================
		public List<SyoboiUpdate> DownloadUpdateList()
		{
			List<SyoboiUpdate> updateList = new List<SyoboiUpdate>();

			try
			{
				//------------------------
				// ڂRSSJ
				//------------------------
				HttpWebRequest webRequest =
					HttpWebRequest.Create(Settings.Default.syoboiProg) as HttpWebRequest;

				webRequest.UserAgent		= UserAgent;
				// O̎擾
				if( prevUpdateListGetTime.HasValue )
					webRequest.IfModifiedSince	= prevUpdateListGetTime.Value;

				WebResponse	webResponse	= webRequest.GetResponse();
				XmlReader	xmlReader	= new XmlTextReader(webResponse.GetResponseStream());

				//------------------------
				// RSSGgParse
				//------------------------
				while (xmlReader.Read())
				{
					if (xmlReader.NodeType == XmlNodeType.Element &&
						xmlReader.LocalName.Equals("item"))
					{
						// <item>
						SyoboiUpdate u = new SyoboiUpdate();

						while (xmlReader.Read())
						{
							if (xmlReader.NodeType == XmlNodeType.Element &&
								xmlReader.LocalName.Equals("link"))
							{
								string t;
								// <link>
								t = xmlReader.ReadElementContentAsString();
								t = t.Substring(t.IndexOf("tid/") + 4);

								u.tid = System.Convert.ToInt32(t);
							}
							else if (xmlReader.NodeType == XmlNodeType.Element &&
									   xmlReader.LocalName.Equals("pubDate"))
							{
								string t;
								t = xmlReader.ReadElementContentAsString();

								u.updateDate = ParsePubDate(t);
							}
							else if (xmlReader.NodeType == XmlNodeType.EndElement &&
									  xmlReader.LocalName.Equals("item"))
								break;
						}

						updateList.Add(u);
					}
				}
				// 擾̂߁A擾L
				prevUpdateListGetTime = DateTime.Now;
			}
			catch(WebException ex)
			{
				bool	ignoreException = false;

				if (ex.Status == WebExceptionStatus.ProtocolError)
				{
					HttpWebResponse	httpRes = ex.Response as HttpWebResponse;

					// O񂩂XVȂ(304G[)ȂO𖳎
					bool	notModfied;
					notModfied	=	(httpRes != null)
								&&	(httpRes.StatusCode == HttpStatusCode.NotModified);

//#if DEBUG
					if( notModfied )
					{
						if( prevUpdateListGetTime.HasValue )
							Logger.Output(	"(ڂ)O擾("
										+	prevUpdateListGetTime.Value.ToShortTimeString()
										+	")XVȂ"	);
					}
//#endif

					ignoreException |= notModfied;
				}

				if (!ignoreException)
					throw;
			}

			return updateList;
		}

		//=========================================================================
		///	<summary>
		///		XVt擾
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		DateTime ParsePubDate(string t)
		{
			int			y, m, d, hour, minute;
			string		[]subStrings;

			subStrings = t.Split(' ');

			//--------------
			// 擾
			//--------------

			string[] Months = {	"JAN","FEB","MAR","APR","MAY","JUN",
								"JUL","AUG","SEP","OCT","NOV","DEC"};

			m = 0;
			foreach (string Month in Months)
			{
				if (Month.Equals( subStrings[2].ToUpper() ))
				{
					m = Array.IndexOf(Months, Month) + 1;
					break;
				}
			}

			//--------------
			// N擾
			//--------------
			y = System.Convert.ToInt32( subStrings[3] );
			d = System.Convert.ToInt32( subStrings[1] );

			//--------------
			// 擾
			//--------------

			t = subStrings[4];
			hour	= Convert.ToInt32(t.Substring(0, t.IndexOf(':')));

			t = t.Substring(t.IndexOf(':') + 1);
			minute	= Convert.ToInt32(t.Substring(0, t.IndexOf(':')));

			return new DateTime(y, m, d, hour, minute, 0);
		}

		//=========================================================================
		///	<summary>
		///		ԑgXg_E[h
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		/// <history>2009/10/08 ڂ鏑ύXɍ킹C</history>
		//=========================================================================
		public List<SyoboiProgram> DownloadPrograms()
		{
			WebClient		wc				= new WebClient();

			wc.Headers.Add( "User-Agent", UserAgent );

			Stream			s				= wc.OpenRead( Properties.Settings.Default.syoboiTitleList );
			StreamReader	streamRender	= new StreamReader(s);
			List<SyoboiProgram>	animeDataBase = new List<SyoboiProgram>();
			string			allText			= "";

			while( !streamRender.EndOfStream )
			{
				allText += streamRender.ReadLine();
			}
			allText = allText.Replace('\t', ' ');

			// ԑgf[^o
			// <tr><td><a href="/tid/1234"> ` </td></tr>
			Regex reg = new Regex("\\<tr\\>" +
								  "(\\s|\\n)*?(?<CONTAIN>\\<td\\>(\\s|\\n)*?<a\\s+href=\\\"/tid/[0-9]+\\\">" +
								  "(.*?)" +
								  "\\</td\\>)" +
								  "(\\s|\\n)*\\</tr\\>" );
			Match		matched = reg.Match( allText );

			for (; matched.Success; )
			{
				string strRow = matched.Groups["CONTAIN"].Value;
				ArrayList Cols = ParseTableRow( strRow );

				animeDataBase.Add(ConvertToSyoboiProgram(Cols));

				matched = matched.NextMatch();
			}

			return animeDataBase;
		}
		
		//=========================================================================
		///	<summary>
		///		w肳ꂽTID̔ԑg̕Xg_E[h
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		/// <history>2009/04/13 ڂVdlɍ킹ĉC</history>
		/// <history>2010/06/01 ڂVdlɍ킹ĉC</history>
		//=========================================================================
		public List<SyoboiRecord> DownloadOnAirList(
			int					tid		,	// [i] ڂTID
			out string			title	)	// [o] ԑg^Cg
		{
			List<String>	source;
			return DownloadOnAirList( tid, out title, out source );
		}

		public List<SyoboiRecord> DownloadOnAirList(
			int					tid		,	// [i] ڂTID
			out string			title	,	// [o] ԑg^Cg
			out List<String>	source	)	// [o] f[^\[X(html)
		{
			WebClient			wc			= new WebClient();

			wc.Headers.Add("User-Agent", UserAgent);

			List<SyoboiRecord>	recordList	= new List<SyoboiRecord>();
			
			//-------------------------------------
			// URL: (ڂTID)/timeJ
			//-------------------------------------
			Stream				s			= wc.OpenRead(
												Properties.Settings.Default.syoboiTid	+
												Convert.ToString(tid)					+
												"/time"									);
			
			StreamReader		streamRender = new StreamReader(s);

			title = null;

			string strRow = "";

			// ꊇ擾Ă
			List<string>	lines	= new List<string>();
			string			allLine	= "";

			for (; !streamRender.EndOfStream; )
			{
				lines.Add( streamRender.ReadLine() );
			}

			foreach( string line in lines )
			{
                //---------------------------------
                // ^Cg<keywords>^O擾
                //---------------------------------
				if (title == null &&
					line.IndexOf("\"keywords\"") >= 0)
				{
					// <meta name="keywords" content="^Cg,EEE">
					Regex	parseTitle	= new Regex(
						"(<meta)(\\s*?)(name=\\\"keywords\\\")(\\s*?)(content=\\\")(?<Title>.*?)(\\s*?)(,)(.*\\\">){1}" );
					Match	matchTitle	= parseTitle.Match(line);

					if( matchTitle.Success )
						// mod yossiepon 20150705 begin
						// title = matchTitle.Groups["Title"].Value;
						title = HttpUtility.HtmlDecode( matchTitle.Groups["Title"].Value );
						// mod yossiepon 20150705 end
				}

				allLine += line;
			}

			//--------------------------------------
			// f[^̂e[u؂o
			//--------------------------------------	
			const string	progComment	= @"(<!)(.*?)(vOꗗ){1}(.*?)(->)";
			Regex			regex		= new Regex( progComment + "(?<Content>.*)" + progComment );
			Match			match		= regex.Match( allLine );
			Group			group		= match.Groups["Content"];

			if (group.Success)
			{
				string tableData = group.Value;

				//------------------------
				// ԃe[ủ
				//------------------------

                // <tr...id="PIDxxxxx">...</tr>ň͂܂ꂽf[^(e[u1s)؂o
				// (<tr class="past" id="PIDxxxxx">܂)
				string	tableFirst		= "(<tr)(\\s*?)(class=\\\"past\\\"(\\s*?))?(id=\\\"PID[0-9]{1,}\\\"){1}(.*?)(>)";
                Regex	findTableCH		= new Regex("(?<FirstPos>" + tableFirst + "(.*?)</tr>" + ")");
				Match	matchTableCH	= findTableCH.Match(tableData);

                for(; matchTableCH.Success ;)
                {
                    strRow = matchTableCH.Groups["FirstPos"].Value;

                    ParseProgramTable( strRow, recordList );

					matchTableCH = matchTableCH.NextMatch();
				}

			}

			streamRender.Close();

			source = lines;

			return recordList;
		}


		//=========================================================================
		///	<summary>
		///		e[u̍sf[^p[Xĕf[^o
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2009/04/13 ڂVdlɍ킹ĉC</history>
		//=========================================================================
		private void ParseProgramTable(
			string				strRow		,	// [i] e[u<td></td>̕
			List<SyoboiRecord>	recordList	)	// [o] f[^
		{
			SyoboiRecord syoboiRecord = null;
		
			try
			{
				ArrayList Cols;
				string temp;

				//---------------------------------------------------------------------------------
				// `l	Jn			Tu^Cg/Rg	tO	XV	-
				//---------------------------------------------------------------------------------
				Cols = ParseTableRow(strRow);
				
				syoboiRecord = new SyoboiRecord();

				syoboiRecord.tvStation = (string)Cols[0]; // TVǖ

				if ( Cols[ 3 ].Equals( "" ) )
				{
					//-----------------------------
					// bȂ΍
					//-----------------------------

					// #nn`#mm
					Regex parser	= new Regex( "^#(?<FirstEpisode>[0-9]+)`#(?<LastEpisode>[0-9]+)" );
					Match match		= parser.Match( (string)Cols[ 4 ] );

					if (match.Success)
					{
						int firstEpisode, lastEpisode;
						int episodeCount = 1;
						DateTime onairDateTime;

						firstEpisode = int.Parse(match.Groups["FirstEpisode"].Value);
						lastEpisode = int.Parse(match.Groups["LastEpisode"].Value);

						syoboiRecord.number = firstEpisode;
						episodeCount = (lastEpisode - firstEpisode + 1); // A

						// =S/b
						syoboiRecord.length = int.Parse((string)Cols[2]) / episodeCount;

						onairDateTime = ConvertToDateTime( (string)Cols[1] );

						//-----------------------------
						// AbAf[^ǉ
						//-----------------------------
						for (int i = firstEpisode; i <= lastEpisode; ++i)
						{
							SyoboiRecord newRecord;

							newRecord = (SyoboiRecord)syoboiRecord.Clone();

							newRecord.number = i;		// bԍ
							newRecord.subtitle = "";	// Tu^Cg

							// Jn
							newRecord.onAirDateTime = onairDateTime.AddMinutes(newRecord.length * (i - firstEpisode));

							recordList.Add(newRecord);
						}
					}
					else
					{
						//------------------------------------------------
						// 2bAu#1A#2v
						//------------------------------------------------
						DateTime		onairDateTime;
						string			dateTag;
						List<int>		episodeNums		= new List<int>();
						List<string>	subTitles		= new List<string>();
						
						// A
						int				totalLen		= int.Parse((string)Cols[2]);

						onairDateTime = ConvertToDateTime( (string)Cols[1] );

						// O҂̏ꍇATu^CgꏏɂȂĂ
						// #nnuTu^CgvA#mmuTu^Cgv...
						parser = new Regex("#(?<EpisodeNumber>[0-9]+)((|u)(?<Subtitle>.*?)(|v))?(A)?");
						match	= parser.Match((string)Cols[4]);

						// Gs\[hԍƃ^CgSĐ؂o
						while(match.Success)
						{
							int		episodeNum	= int.Parse(match.Groups["EpisodeNumber"].Value);
							string	subTitle	= (string)match.Groups["Subtitle"].Value;

							episodeNums.Add( episodeNum );
							subTitles.Add( subTitle );

							match = match.NextMatch();
						}

						// O҂̏ꍇ̃Tu^Cg
						if( subTitles.Count == 2 )
						{
							if( string.IsNullOrEmpty( subTitles[0] ) &&
								!string.IsNullOrEmpty( subTitles[1] ) )
							{
								subTitles[0] = subTitles[1];
							}
						}

						// eGs\[hǉ
						for( int i = 0 ; i < episodeNums.Count ; ++i )
						{
							int		episodeNum	= episodeNums[i];
							string	subTitle	= subTitles[i];

							SyoboiRecord newRecord = (SyoboiRecord)syoboiRecord.Clone();

							// =S/b
							newRecord.length	= totalLen / episodeNums.Count;
							newRecord.number	= episodeNum;	// Gs\[hԍ
							newRecord.subtitle	= subTitle;		// Tu^Cg

							// Jn
							newRecord.onAirDateTime = onairDateTime.AddMinutes(newRecord.length * i);

							recordList.Add(newRecord);
						}
					}
				}
				else
				{
					syoboiRecord.length = int.Parse( (string)Cols[ 2 ] ); // 
					syoboiRecord.number = int.Parse( (string)Cols[ 3 ] ); // bԍ

					// HTMLGR[hfR[h
					syoboiRecord.subtitle = HttpUtility.HtmlDecode( MakeNaked( (string)Cols[ 4 ] ) ); // Tu^Cg
					syoboiRecord.onAirDateTime = ConvertToDateTime( (string)Cols[1] );	// Jn

					recordList.Add( syoboiRecord );
				}

			}
			catch(Exception)
			{
#if _DEBUG
//				if (syoboiRecord!=null)
//					Console.WriteLine(title + " " + syoboiRecord.number);
#endif
			}
		}

		//=========================================================================
		///	<summary>
		///		XgǂXgAbv
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public ArrayList ListupTvStation(List<SyoboiCalender.SyoboiRecord> recordList)
		{
			ArrayList tvStationList = new ArrayList();
		
			foreach(SyoboiCalender.SyoboiRecord record in recordList)
			{
				bool addToList = true;

				foreach(string tvStation in tvStationList)
				{
					if (record.tvStation.Equals(tvStation))
					{
						addToList = false;
						break;
					}
				}
				
				if (addToList)
					tvStationList.Add(record.tvStation);
			}
		
			return 	tvStationList;
		}

		//=========================================================================
		///	<summary>
		///		ԑghtmle[u̍\̌`ɕϊ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		private SyoboiProgram ConvertToSyoboiProgram(ArrayList Cols)
		{
			SyoboiProgram newProgram = new SyoboiProgram();

			newProgram.title = (string)Cols[0];
			newProgram.tid = int.Parse((string)Cols[3]);

			newProgram.seasonOnAir.RecordState = 0;
			
			string seasonOnAir = (string)Cols[1];
			
			seasonOnAir = seasonOnAir.Trim();
			if( seasonOnAir.Equals("-------") )
			{
			}else{
				string year, month;

				year = seasonOnAir.Substring( 0, 4 );
				if( !year.Equals("----") )
				{
					newProgram.seasonOnAir.RecordState |= SyoboiProgram.SeasonOnAir.YearDecided;
					newProgram.seasonOnAir.year = int.Parse(year);
				}
				
				month	= seasonOnAir.Substring( seasonOnAir.Length - 2 );
				if(! month.Equals("--") )
				{
					newProgram.seasonOnAir.RecordState |= SyoboiProgram.SeasonOnAir.MonthDecided;
					newProgram.seasonOnAir.month	= int.Parse( month );
				}

			}
		
			return newProgram;
		}
		
		//=========================================================================
		///	<summary>
		///		ڂ̓tDateTimeɕϊ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		private DateTime ConvertToDateTime(
			string strDateTime)	// [i] u2009-02-02 () 10:30v
		{
			DateTime dateTime;
			int		year;
			int		month;
			int		day;
			int		hour;
			int		minute;
			bool incDay = false;

			Regex	regex = new Regex(
				"(?<Year>[0-9]{4})-(?<Month>[0-9]{1,})-(?<Day>[0-9]{1,})( *?)(.*?)( *?)" +
				"(?<Hour>[0-9]{1,}):(?<Minute>[0-9]{1,})");
			Match	match = regex.Match( strDateTime );

			year	= int.Parse( match.Groups["Year"].Value );
			month	= int.Parse(match.Groups["Month"].Value);
			day		= int.Parse(match.Groups["Day"].Value);
			hour	= int.Parse(match.Groups["Hour"].Value);
			minute	= int.Parse(match.Groups["Minute"].Value);


			// 24:00ȍ~Ȃ+1
			if (hour >= 24)
			{
				hour -= 24;
				incDay = true;
			}

			dateTime = new DateTime(
				year	,
				month	,
				day		,
				hour	,
				minute	,
				0		);

			if (incDay)
				dateTime = dateTime.AddDays(1.0);

			return dateTime;
		}

		//=========================================================================
		///	<summary>
		///		html^Or
		///	</summary>
		/// <remarks>
		///		Ƃ肠ApɂɏoĂ<a><div>폜B
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		private string MakeNaked(string context)
		{
			string nakedContext = context;

			{
				Regex regex = new Regex("<a(.*?)>(?<Content>(.*?))</a>");
				Match match = regex.Match(nakedContext);

				if (match.Groups["Content"].Success)
				{
					string content = match.Groups["Content"].Value;

					nakedContext = regex.Replace(context, content);
				}
			}

			// <TAG*>xxxx</TAG>`̃^O
			string[]	targetTags = {"div", "span"};

			foreach( string target in targetTags )
			{
				Regex regex = new Regex("<" + target +"(.*?)>(.*?)</" + target + ">");
				Match match = regex.Match(nakedContext);

				if (match.Success)
				{
					nakedContext = regex.Replace(nakedContext, "");
				}
			}

			return nakedContext;
		}
		
		//=========================================================================
		///	<summary>
		///		HTML̃e[u̍s<TD>...</TD>񂲂Ƃɕ
		///	</summary>
		/// <remarks>
		///		<tr></tr>ZNVň͂܂ꂽ̕n
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		private ArrayList ParseTableRow(string strRow)
		{
			ArrayList Cols = new ArrayList();
			string strCol;

			Regex	regex	= new Regex("(<td)(.*?)(>)(?<Content>(.*?))(</td>)");
			Match	match	= regex.Match( strRow );

			for (; match.Success; )
			{
				string	content = (string)match.Groups["Content"].Value;
				Cols.Add( MakeNaked( content ) );
				match = match.NextMatch();
			}
			
			return Cols;
		}
		
		//=========================================================================
		///	<summary>
		///		w肳ꂽ^Oň͂܂ꂽ͈͂̕Ԃ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		private string ExtractTagContain(
			string		line	,
			string		tagName	)
		{
			string dummy;
			
			return ExtractTagContain( line, tagName , out dummy );
		}

		//=========================================================================
		///	<summary>
		///		w肳ꂽ^Oň͂܂ꂽ͈͂̕Ǝc̕Ԃ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		private string ExtractTagContain(
			string		line		,	// [i] 
			string		tagName		,	// [i] ^O
			out string	remain		)	// [o] c蕶
		{
			try
			{
				Regex reg = new Regex(@"\<" + tagName + @"\>(?<CONTAIN>.*?)\</" + tagName + @"\>");
				Match matched = reg.Match(line);

				if (matched.Success)
				{
					string contain = matched.Groups["CONTAIN"].Value;
					remain = reg.Replace(line, "");
					return contain;
				}
			}
			catch (Exception ex)
			{
			}

			remain = line;
			return "";
		}
		
	}

}
